﻿using gov.va.med.vbecs.Common;
using System;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// Used to display exceptions to the user and store their associated override message/comment
    /// </summary>
    public class ExceptionForDisplayModel : IEquatable<ExceptionForDisplayModel>
    {
        /// <summary>
        /// ExceptionType
        /// </summary>
        public ExceptionType ExceptionType { get; private set; }
        /// <summary>
        /// PromptCaption
        /// </summary>
        public string PromptCaption { get; private set; }
        /// <summary>
        /// PromptMessage
        /// </summary>
        public string PromptMessage { get; private set; }
        /// <summary>
        /// OverrideMessage
        /// </summary>
        public string OverrideMessage { get; set; }
        /// <summary>
        /// CannedCommentCategory
        /// </summary>
        public string CannedCommentCategory { get; set; }
        /// <summary>
        /// Constructor
        /// </summary>
        public ExceptionForDisplayModel(ExceptionType exceptionType, string promptCaption, string promptMessage, string cannedCommentCategory)
        {
            ExceptionType = exceptionType;
            PromptCaption = promptCaption;
            PromptMessage = promptMessage;
            CannedCommentCategory = cannedCommentCategory;
        }
        /// <summary>
        /// Cloone
        /// </summary>
        /// <returns></returns>
        public ExceptionForDisplayModel Clone()
        {
            var clone = new ExceptionForDisplayModel(ExceptionType, PromptCaption, PromptMessage, CannedCommentCategory);
            clone.OverrideMessage = OverrideMessage;
            return clone;
        }
        /// <summary>
        /// Equals
        /// </summary>
        /// <param name="other"></param>
        /// <returns></returns>
        public bool Equals(ExceptionForDisplayModel other)
        {
            if (ReferenceEquals(null, other)) return false;
            if (ReferenceEquals(this, other)) return true;

            return string.Equals(OverrideMessage, other.OverrideMessage)
                && string.Equals(PromptMessage, other.PromptMessage)
                && string.Equals(PromptCaption, other.PromptCaption)
                && string.Equals(CannedCommentCategory, other.CannedCommentCategory)
                && ExceptionType == other.ExceptionType;
        }
        /// <summary>
        /// Equals
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            if (obj.GetType() != this.GetType()) return false;
            return Equals((ExceptionForDisplayModel)obj);
        }
        /// <summary>
        /// GetHashCode
        /// </summary>
        /// <returns></returns>
        public override int GetHashCode()
        {
            unchecked
            {
                int hashCode = (OverrideMessage != null ? OverrideMessage.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (PromptMessage != null ? PromptMessage.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (PromptCaption != null ? PromptCaption.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (CannedCommentCategory != null ? CannedCommentCategory.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (int)ExceptionType;
                return hashCode;
            }
        }
    }
}
